#ifndef __WINDOW_HPP__
#define __WINDOW_HPP__

#include <QMainWindow>
#include <QString>
#include <QList>

class Widget;
class QAction;
class QLabel;
class QTimer;
class QSlider;
class QSpinBox;
class QGridLayout;
class QVBoxLayout;
class QMenu;

class Window : public QMainWindow
{
	Q_OBJECT
	
	private:
	
	public:
		/**
		 * Constructor of the Window
		 * @param QWidget* the parent
		 * @param const QString& the title
		 */
		Window(QWidget* parent = 0, const QString& title = "QT Window");
		~Window(void);
		
	public slots:
		void openSong(void);
		void aboutBox(void);
		
		void play(void);
		void pause(void);
		void stop(void);
		
		/**
		 * Will move the song position
		 * @param int the new position
		 */
		void seek(int newValue);
		

		void updateSongPosition(void);
		void updateAnalizer(void);
		
		/**
		 * Block the spin box with power of two values
		 * @param const int the new number of frequencies
		 */
		void updateFrequencyMaxSelector(int nbFrequencies);
		
		/**
		 * Add spetrum to be analized
		 * @param int the new number of spectrum to be analized
		 */		
		void updateFrequenciesSelector(int nbSliders);
		
	private:
	
		QString currentPath;		/// Keep the path of the last folder used
		QString currentSong;		/// Keep the name of the song
		
		// Menu related:
		QAction* playAction;		/// Keep the pointer on the menu entry "play" (to disabled it)
		QAction* pauseAction;		/// Keep the pointer on the menu entry "pause" (to disabled it)
		QAction* stopAction;		/// Keep the pointer on the menu entry "stop" (to disabled it)
		
		QLabel* statusMessage;		/// Status bar (bottom of the window)
		
		// Song position related:
		QLabel* positionLabel;		/// Text displaying the song position
		QSlider* positionSlider;	/// Slider displaying the song position
		QTimer* updatePositionTimer;	/// Timer to update the position
		
		// Analizer settings related:
		QSpinBox* nbFrequenciesSelector;
		QSpinBox* nbFrequencyMaxSelector;
		
		// Analizer related:
		QGridLayout* frequenciesBox;				/// Contain the QVBoxLayout of the  spectrum analized
		QList<QVBoxLayout*> * frequenciesBoxes;		/// Contain the spectrum analized (QSlider + QSpinBox)
		QList<QSlider*> * frequenciesSliders;
		QList<QSpinBox*> * frequenciesSpinBoxes;
		
		unsigned int nbFrequenciesSet;				/// Counter for the spectrum analized
		
		QTimer* updateAnalizerTimer;	/// Timer for the analizer
		
		// Song related:
		float* spectrum;	/// The array of the spectrum (filled by FMOD)
		
		// Avoid some repetitive calculus
		unsigned int songMsLength;
		unsigned int songSLength;
		unsigned int songMLength;

		
		// Functions:
		
		/**
		 * Create a new entry in the QMenu*
		 * 
		 * @param QMenu* the parent menu of the entry
		 * @param const QString& the name of the entry
		 * @param const QString& the key sequence to set to the menu
		 * @param const QString& the tip displayed when the cursor is on the entry
		 * @param const QObject* the pointer of the receiver of the connection
		 * @param const char* the function called when the signal is emitted
		 * @param const bool false if the menu is disabled
		 * @return QAction* return the entry newly created
		 * @brief - Create the entry
		 * 		  - Assign a shortcut
	 	 *	  	  - Assign a status description
	 	 * 		  - Set if the menu is enabled or not
		 * 		  - Connect the funtion
	 	 */
		QAction* addAction(QMenu* parentMenu, const QString& entryName, const QString& keySequence, const QString& statusTipMessage, const QObject* object, const char* slot, const bool enabled = true);

		/**
		 * Add a new view on a spectrum by adding a slider and a spin box		
		 */
		void addSpectrum(void);
};

#endif
