#ifndef __SINGLETON_HPP__
#define __SINGLETON_HPP__

#include <iostream>	// For the NULL declaration

namespace Utils
{
	/**
	 * Class to implement the Singleton pattern
	 * All class that inherits this one will be a singleton
	 * @author Alexandre LAURENT
	 */
	template <class T>
	class Singleton
	{
		private:
			static T* instance;		///< Instance of the class (Singleton pattern)
			
			// Block the copy
			Singleton(Singleton&);
			void operator= (Singleton&);
		
		protected:
			Singleton() {};
			~Singleton() {};
		
		public:
			/**
			 * Get the instance of the class
			 * @return T& the instance
			 */
			static T& getInstance()
			{
				if ( instance == NULL )
					instance = new T;
				return *instance;
			}
			
			/**
			 * Delete the instance of the class
			 */
			static void deleteInstance()
			{
				delete instance;
				instance = NULL;
			}
	};
	
	template <class T>T* Singleton<T>::instance = NULL;
}

#endif
