#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include <omp.h>

#include "probe_time.h"
#include "probe_msr.h"

#define COUNTER 50000000

int main(int argc, char** argv)
{
   int msrFD = 0;
   double startPower=0;
   double endPower=0;
   long long unsigned startTime=0;
   long long unsigned endTime=0;
   
   unsigned int nbThreads=0;
   

   if ( argc != 2 )
   {
      fprintf(stderr,"Vous devez passez un et un seul argument (le nombre de threads à utiliser)\n");
      return -2;
   }
   if ( sscanf(argv[1], "%d",&nbThreads) != 1 )
   {
      fprintf(stderr,"Vous devez passer un nombre en argument\n");
      return -2;
   }
   
   msrFD = open_msr(0);
   if ( msrFD < 0 )
   {
      fprintf(stderr,"Fail to init MSR probe\n");
      return -1;
   }
   
   // Première mesure
   startTime = getTime();
   startPower = readPower(msrFD);
   
   printf("Threads : %d\n",nbThreads);
   
   // Test
   {
      unsigned int n = 0;
      unsigned int i = 0;
      
      #pragma omp parallel for num_threads(nbThreads) private(n)
      for (n = 0 ; n < COUNTER ; n++ )
      {
         #pragma omp critical
         {
            i+=sqrt(i);
         }
      }
      
      printf("Result %d\n",i);
   }
   
   // Seconde mesure
   endPower = readPower(msrFD);
   endTime = getTime();
   
   // On affiche la différence entre les deux mesures pour avoir une consommation
   printf("Energie : %f (J) | Temps : %llu (ms) | Puissance : %f (W)\n",endPower-startPower,endTime-startTime,(endPower-startPower)/((double)(endTime-startTime)/1000.0));
   
   // Nettoyage
   close(msrFD);
   
   return 0;
}
