#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include <omp.h>

#include "probe_time.h"
#include "probe_msr.h"

#define COUNTER 50000000

int main(int argc, char** argv)
{
   (void)argc;
   (void)argv;
   
   int msrFD = 0;
   double startPower=0;
   double endPower=0;
   long long unsigned startTime=0;
   long long unsigned endTime=0;
   
   
   msrFD = open_msr(0);
   if ( msrFD < 0 )
   {
      fprintf(stderr,"Fail to init MSR probe\n");
      return -1;
   }
   
   // Première mesure
   startTime = getTime();
   startPower = readPower(msrFD);
   
   printf("Threads : %d\n",omp_get_max_threads());

   // Test
   {
      unsigned int n = 0;
      unsigned int i = 0;
      
      #pragma omp parallel for private(n) reduction(+:i)
      for (n = 0 ; n < COUNTER ; n++ )
      {
         i+=sqrt(i);
      }
      
      printf("Result %d\n",i);
   }
   
   // Seconde mesure
   endPower = readPower(msrFD);
   endTime = getTime();
   
   // On affiche la différence entre les deux mesures pour avoir une consommation
   printf("Energie : %f (J) | Temps : %llu (ms) | Puissance : %f (W)\n",endPower-startPower,endTime-startTime,(endPower-startPower)/((double)(endTime-startTime)/1000.0));
   
   // Nettoyage
   close(msrFD);
   
   return 0;
}
