#include <stdio.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <errno.h>
#include <math.h>
#include <stdlib.h>

#define MSR_RAPL_POWER_UNIT		0x606
#define MSR_PKG_ENERGY_STATUS		0x611

int open_msr(int core)
{
  char msr_filename[BUFSIZ];
  int fd;

  sprintf(msr_filename, "/dev/cpu/%d/msr", core);
  fd = open(msr_filename, O_RDONLY);
  if ( fd < 0 ) // Erreur
  {
    if ( errno == ENXIO ) 
    {
      fprintf(stderr, "rdmsr: No CPU %d\n", core);
    } 
    else if ( errno == EIO ) 
    {
      fprintf(stderr, "rdmsr: CPU %d doesn't support MSRs\n", core);
    } 
    else 
    {
      perror("rdmsr:open");
      fprintf(stderr,"Trying to open %s\n",msr_filename);
    }
  }

  return fd;
}

long long read_msr(int fd, int which) 
{
  size_t data;

  if ( pread(fd, &data, sizeof data, which) != sizeof data ) 
  {
    perror("rdmsr:pread");
  }

  return (long long)data;
}

double readPower(int fd)
{
   long long counter = 0;
   double energy_units = 0;
   double power = 0;
   
   counter = read_msr(fd,MSR_RAPL_POWER_UNIT);
   energy_units = pow(0.5,(double)((counter>>8)&0x1f));
   
   counter = read_msr(fd,MSR_PKG_ENERGY_STATUS);  
   power = (double)counter*energy_units;
   
   return power;
}
