#include "time_manager.hpp"

#include <iostream>

#include <sys/time.h>
#include <signal.h>

/**
	Time_manager's constructor
	@param unsigned int nbFPSperSecond : number of FPS per second to slow down
*/
Time_manager :: Time_manager(unsigned int nbFPSperSecond)
{	
	start_time=getMicroSecond();
	
	frame_counter=0;
	time_counter=getSecond();
	waiting_time = (unsigned int)(1000000.0/nbFPSperSecond);
	
	#ifdef __DEBUG_TIME__
		std::cout << waiting_time << std::endl;
	#endif
}

/**
	function to get the time in micro second
	@return long unsigned int : time in micro second
*/
long unsigned int Time_manager::getMicroSecond()
{
	struct timeval time;
	
	if ( gettimeofday(&time,NULL) != 0 )
	{
		std::cerr << "Erreur lors de la récupération des millisecondes" << std::endl;
		return 0;
	}
	else
		return time.tv_usec;
}

/**
	function to get the time in second
	@return long unsigned int : time in second
*/
long unsigned int Time_manager::getSecond()
{
	struct timeval time;
	
	if ( gettimeofday(&time,NULL) != 0 )
	{
		std::cerr << "Erreur lors de la récupération des secondes" << std::endl;
		return 0;
	}
	else
		return time.tv_sec;
}

/**
	Function to wait the correct time for have the asked number of FPS
*/
void Time_manager::waitForFPS()
{
	long int diff_time = getMicroSecond() - start_time;
	
	#ifdef __DEBUG_TIME__
		std::cout << "diff_time : " << diff_time << " start time : " << start_time << std::endl;
	#endif
	
	if ( diff_time < (long int)waiting_time )
	{	
		if ( diff_time > 0 )
		{
			usleep(waiting_time-diff_time);
			
			#ifdef __DEBUG_TIME__
				std::cout << " Dormir : " << waiting_time-diff_time << std::endl;
			#endif
		}
		start_time = getMicroSecond();			
	}
}

/**
	Function to count and display each second the number of FPS
*/
void Time_manager::countFPS()
{
	#ifdef __DEBUG_TIME__
		std::cout << " FPS_current : " << frame_counter << " Second current : " << getSecond() << " Second pass : " << time_counter << std::endl;
	#endif
	frame_counter++;
	
	if ( time_counter != getSecond() )
	{
		time_counter = getSecond();
		std::cout << " FPS : " << frame_counter << std::endl;
		frame_counter = 0;
	}
}
