#include "son.hpp"

#include <iostream>
#include <vector>

#include <FMOD/fmod.h>

using namespace std;

Son* Son::sing_son=NULL;

/**
	Son's constructor
	Start the FMOD library
*/
Son::Son()
{
	#ifdef __DEBUG_SON__
		cout<<"Son construit" << endl;
	#endif
	
	if ( FSOUND_SetOutput(FSOUND_OUTPUT_OSS) == 0 )
	{
		cerr << "Son Error : ALSA\n->\tTrying OSS" << endl;
		if ( FSOUND_SetOutput(FSOUND_OUTPUT_OSS) == 0 )
		{
			cerr << "Son Error : OSS\n->\tNo sound" << endl;
		}
	}
	
	if ( FSOUND_Init(44100, 32, 0) == 0 )
	{
		cerr << "FMOD initialization failed" << endl;
	}
}

/**
	As Son is a singleton, this getter return the instance
*/
Son* Son::getSon()
{
	if ( sing_son == NULL )
		sing_son = new Son();
	return sing_son;
}

/**
	Function to load a music
	@param char* music_path : the path of the music to load it
	@param char looping_mode : if we set the looping mode or not
	@return char : if an error occurs ; 0 no error
*/
char Son :: loadMusic(char* music_path, char looping_mode)
{
	FMUSIC_MODULE* stream = NULL;
	
	#ifdef __DEBUG_SON__
		cout << "init" << endl;
		cout << "Path : " << music_path << endl;
	#endif
	
	stream = FMUSIC_LoadSong(music_path);
	
	#ifdef __DEBUG_SON__
		cout << "open" << endl;
	#endif
	
	if ( stream != NULL )
		musics.push_back(stream);
	else
	{
		cerr << "Erreur de chargement du fichier : " << music_path << endl;
		return 3;
	}
		
	#ifdef __DEBUG_SON__
		else
			cout << "real error stream" << endl;
		cout << "push.back" << endl;
	#endif
	
	if ( musics.back() == NULL )
	{
		cerr << "Error while loading the music : " << music_path << endl;
		return 1;
	}
	
	#ifdef __DEBUG_SON__
		cout << "push.back 2" << endl;
	#endif
	
	if ( FMUSIC_SetLooping(musics.back(), looping_mode) == 0 )
	{
		fprintf(stderr,"Erreur pour mettre en boucle de la musique\n");
		return 2;
	}
	
	return 0;
}

/**
	Function to play a music
	@param unsigned int id_musique : the number of the music ( or position in the vector )
	@param char : if an error occurs ; 0 no error
*/
char Son::playSong(unsigned int id_musique)
{
	if ( FMUSIC_PlaySong(musics[id_musique]) == -1 )
	{
		cerr << "Error while playing music : " << id_musique << endl;
		return 1;
	}
	
	return 0;
}

/**
	Function to call the destructor of Son ( Son is a singleton )
*/
void Son:: destroySon()
{
	if ( sing_son != NULL )
	{
		delete sing_son;
		sing_son = NULL;
	}
}

/**
	Function to get the current volume of the music
	@return unsigned char : the volume
*/
unsigned char Son::getVolume()
{
	return FSOUND_GetVolume(FSOUND_ALL);
}

/**
	Function to set the current volume of the music
	@param unsigned char : the volume
*/
void Son::setVolume(unsigned char volume)
{
	FSOUND_SetVolume(FSOUND_ALL, volume);
}

/**
	Son's destructor
	Close all musics
	Close FMOD
*/
Son::~Son()
{
	for ( unsigned int i = 0 ; i < musics.size() ; i++ )
		FMUSIC_FreeSong(musics[i]);
		
	FSOUND_Close();
}
