#include "scene0.hpp"
#include "star.hpp"

#include <GL/gl.h>

/**
	Initialises the scene
*/
void initScene0()
{
	initStars();
}

/**
	Draws the scene
*/
void drawScene0()
{
	drawStars();
}

/**
	Deletes the scene
*/
void deleteScene0()
{
	deleteStars();
}

/**
	Initialises the light
*/
void initLight()
{
	glEnable(GL_LIGHTING);

	GLfloat light_diffuse[] = { 1.0, 1.0, 1.0, 1.0 };
	GLfloat light_specular[] = { 0.0, 0.0, 0.0, 1.0 };
	

	{
		GLfloat light_ambient[] = { 1.0, 0.0, 0.0, 1.0 };
		glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT0, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, 0.2);
	}
	
	{
		GLfloat light_ambient[] = { 1.0, 1.0, 0.0, 1.0 };
		glLightfv(GL_LIGHT1, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT1, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT1, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT1, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT1, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT1, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT1, GL_QUADRATIC_ATTENUATION, 0.2);
	}
	
	{
		GLfloat light_ambient[] = { 1.0, 0.0, 1.0, 1.0 };
		glLightfv(GL_LIGHT2, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT2, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT2, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT2, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT2, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT2, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT2, GL_QUADRATIC_ATTENUATION, 0.2);
	}
	
	{
		GLfloat light_ambient[] = { 0.0, 1.0, 1.0, 1.0 };
		glLightfv(GL_LIGHT3, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT3, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT3, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT3, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT3, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT3, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT3, GL_QUADRATIC_ATTENUATION, 0.2);
	}

	{	
		GLfloat light_ambient[] = { 1.0, 0.0, 0.0, 1.0 };
		glLightfv(GL_LIGHT4, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT4, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT4, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT4, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT4, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT4, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT4, GL_QUADRATIC_ATTENUATION, 0.2);
	}
	
	{
		GLfloat light_ambient[] = { 0.0, 0.0, 1.0, 1.0 };
		glLightfv(GL_LIGHT5, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT5, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT5, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT5, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT5, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT5, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT5, GL_QUADRATIC_ATTENUATION, 0.2);
	}
	
	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHT1);
	glEnable(GL_LIGHT2);
	glEnable(GL_LIGHT3);
	glEnable(GL_LIGHT4);
	glEnable(GL_LIGHT5);
}

/**
	Initialises the light ( second configuration )
*/
void initLight2()
{
	glEnable(GL_LIGHTING);

	GLfloat light_diffuse[] = { 1.0, 1.0, 1.0, 1.0 };
	GLfloat light_specular[] = { 0.0, 0.0, 0.0, 1.0 };
	

	{
		GLfloat light_ambient[] = { 1.0, 0.0, 0.0, 1.0 };
		glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT0, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, 0.2);
	}
	
	{
		GLfloat light_ambient[] = { 1.0, 1.0, 0.0, 1.0 };
		glLightfv(GL_LIGHT1, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT1, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT1, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT1, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT1, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT1, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT1, GL_QUADRATIC_ATTENUATION, 0.2);
	}
	
	{
		GLfloat light_ambient[] = { 1.0, 0.0, 0.0, 1.0 };
		glLightfv(GL_LIGHT2, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT2, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT2, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT2, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT2, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT2, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT2, GL_QUADRATIC_ATTENUATION, 0.2);
	}
	
	{
		GLfloat light_ambient[] = { 1.0, 1.0, 0.0, 1.0 };
		glLightfv(GL_LIGHT3, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT3, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT3, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT3, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT3, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT3, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT3, GL_QUADRATIC_ATTENUATION, 0.2);
	}

	{	
		GLfloat light_ambient[] = { 1.0, 0.0, 0.0, 1.0 };
		glLightfv(GL_LIGHT4, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT4, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT4, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT4, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT4, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT4, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT4, GL_QUADRATIC_ATTENUATION, 0.2);
	}
	
	{
		GLfloat light_ambient[] = { 1.0, 1.0, 0.0, 1.0 };
		glLightfv(GL_LIGHT5, GL_AMBIENT, light_ambient);
		glLightfv(GL_LIGHT5, GL_DIFFUSE, light_diffuse);
		glLightfv(GL_LIGHT5, GL_SPECULAR, light_specular);
		glLightf(GL_LIGHT5, GL_SPOT_CUTOFF, 180.0);
		glLightf(GL_LIGHT5, GL_CONSTANT_ATTENUATION, 1.5);
		glLightf(GL_LIGHT5, GL_LINEAR_ATTENUATION, 0.5);
		glLightf(GL_LIGHT5, GL_QUADRATIC_ATTENUATION, 0.2);
	}
	
	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHT1);
	glEnable(GL_LIGHT2);
	glEnable(GL_LIGHT3);
	glEnable(GL_LIGHT4);
	glEnable(GL_LIGHT5);
}
