#include "draw_stuff.hpp"

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>

#include "math.h"

#include "time_manager.hpp"
#include "son.hpp"
#include "image.hpp"
#include "scene0.hpp"
#include "scene1.hpp"
#include "scene2.hpp"


#include <iostream>	

void drawGL()
{	
	static int tex = LoadGLTextures("./Data/gfx/Stars.bmp");
	static int popsy = LoadGLTextures("./Data/gfx/Greet1.bmp");
	static int cocoon = LoadGLTextures("./Data/gfx/Greet2.bmp");
	static int dtv = LoadGLTextures("./Data/gfx/Greet3.bmp");
	static int you = LoadGLTextures("./Data/gfx/Greet4.bmp");
	static int sector = LoadGLTextures("./Data/gfx/Greet8.bmp");
	static int mankind = LoadGLTextures("./Data/gfx/Greet7.bmp");
	static int division = LoadGLTextures("./Data/gfx/Greet6.bmp");
	static int sfx = LoadGLTextures("./Data/gfx/Greet5.bmp");
	
	static int code = LoadGLTextures("./Data/gfx/code.bmp");
	static int littlewhite = LoadGLTextures("./Data/gfx/LittleWhite.bmp");
	static int music = LoadGLTextures("./Data/gfx/music.bmp");
	static int okeanos = LoadGLTextures("./Data/gfx/Okeanos.bmp");
	
	
	static int scene = 0;

		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	
    	glLoadIdentity();
    
    //drawAxis();
    
    switch ( scene )	// Scenes switcher
    {
    	case 0 :	
    		{		
    				static bool init = true;
    				static float indice = 0.0;
    				static float look_z = 0.0;
    				static char passage = 0;
    				
    				gluLookAt(	look_z/2.0 ,10.0, 0.0f,
    							look_z, 0.0f, look_z,
    							0.0f, 0.0f ,1.0f );  
    							
    				glDisable(GL_LIGHTING);
    				
    				if ( init )
    				{
    					glColor3ub(255,255,255);
    					initScene0();
    					init = false;
					}
    				
    				drawScene0();
    				
    				
    				
    				look_z = (sinf(indice)*10);
    				
    				indice += 0.01;
    				
    				if ( indice > 12.56  )
    					passage++;
    					
    				if ( passage == 2 )
    					scene++;

    				break;
			}
			
		case 1 :	
    		{		
    				static char passage = 0;
    				static int limite = 1;
    				
    				gluLookAt(	0.0 ,10.0, 0.0f,
    							0.0 , 0.0f, 0.0 ,
    							0.0f, 0.0f ,1.0f );  
    				
    				for ( int i = 0 ; i < limite ; i ++ )
    				{
    					drawScene0(); 					
    					glTranslatef ( 0.0 , i/10.0 , 0.0 );
					}
					
					passage ++;
					if ( passage >= 10 - (limite-2) )
					{
						passage = 0;
						limite++;
					}
					if ( limite > 12 )
						scene++;

    				
    				break;
			}
			
		case 2 :	
    		{		
    				static unsigned short int angle = 0;
    				static float vue_y = 10.0;
    				
    				gluLookAt(	0.0 ,vue_y, 0.0f,
    							0.0 , 0.0f, 0.0 ,
    							0.0f, 0.0f ,1.0f );  
    				
    				
    				glRotated ( angle , 0 , 1 , 0 );
    				if ( angle > 270 )
    					glRotated ( angle-270 , 0 , 0 , 1 );
    				if ( angle > 540 )
    					if ( vue_y > 1 )
    						vue_y -= 0.1;
    				
    				for ( int i = 0 ; i < 12 ; i ++ )
    				{    						
    					drawScene0();
    					glTranslatef ( 0.0 , i/10.0 , 0.0 );
					}
					
					angle ++ ;
					
					if ( angle > 760 )
						scene+=2;

    				
    				break;
			}
			
		case 4 :
			{
					static unsigned short int waiting = 0;
    				static unsigned short int angle = 761;
    				static bool init = true;
    				static double indice = 0;
    				
    				if ( init )
    				{
    					initLight();
    					init = false;
					}
    				
    				
    				gluLookAt(	0.0 , 10.0f , 0.0f,
    							0.0 , 0.0f, 0.0 ,
    							0.0f, 0.0f ,1.0f );  
    				
    				
    				glRotated ( angle , 0 , 1 , 0 );
    				glRotated ( angle-270 , 0 , 0 , 1 );
    				
    				float sin_calc = sinf(indice)*10;
    				
    				GLfloat light_position1[] = { sin_calc , 0.0 , 0.0 , 1.0 };
    				GLfloat light_position0[] = { sin_calc , 0.0 , sin_calc , 1.0 };
    				GLfloat light_position2[] = { sin_calc , sin_calc , sin_calc , 1.0 };
    				GLfloat light_position3[] = { sin_calc , 0.0 , sin_calc , 1.0 };
    				GLfloat light_position4[] = { 0.0 , sin_calc , 0.0 , 1.0 };
    				GLfloat light_position5[] = { 0.0 , 0.0 , sin_calc , 1.0 };
    				
    				glLightfv(GL_LIGHT0, GL_POSITION, light_position0);
    				glLightfv(GL_LIGHT1, GL_POSITION, light_position1);
    				glLightfv(GL_LIGHT2, GL_POSITION, light_position2);
    				glLightfv(GL_LIGHT3, GL_POSITION, light_position3);
    				glLightfv(GL_LIGHT4, GL_POSITION, light_position4);
    				glLightfv(GL_LIGHT5, GL_POSITION, light_position5);
    					
    				
    				for ( int i = 0 ; i < 12 ; i ++ )
    				{    						
    					drawScene0();
    					glTranslatef ( 0.0 , i/10.0 , 0.0 );
					}
			
					indice+=0.1;
					angle++;
					
					if ( waiting >= 400 )
						scene++;
					waiting++;
    				
    				break;
			}
		
		case 5 : 	
			{
					static unsigned int waiting = 0;
					static bool init = true;
					
					if ( init )
					{
						deleteScene0();
						init = false;
					}
					
					gluLookAt(	0.0f ,5.0, 0.0,
    							0.0f, 0.0f, 0.0f,
    							0.0f, 0.0f ,1.0f );
    					
    				glDisable(GL_LIGHTING);
    							
    				drawPlane(tex);
    				
    				waiting ++;
    				if ( waiting > 300 )
    					scene++;
    				
    				break;
    		}		
			
    	
    	case 6 : 	
    		{
    				static unsigned int waiting = 0;    			
    				static bool init = true;
    				static float vue_z = 5.0;

    				
    				gluLookAt(	0.0f ,10.0, vue_z,
    							0.0f, 0.0f, 0.0f,
    							0.0f, 0.0f ,1.0f );  
    				
    				glDisable(GL_LIGHTING);
    				
    				if ( init )
    				{
    					initScene1();
    					init = false;
					}
					
					if ( waiting < 30 )
					{
						glColor3f ( 1.0f , 0.0f, 0.0f);
						drawScene1();
					}
					else if ( waiting >= 30 && waiting < 60 )
					{
					}
					else if ( waiting > 60 )
					{
						glRotated(waiting-60, 0, 1, 0);
						
						glColor3f( 0.0f, 1.0f, 0.0f );
						drawScene1();
						
						glColor3f(1.0f, 0.0f, 0.0f );
						glPushMatrix();
						glTranslatef( 2.5 , 0.0 , 0.0 );
						drawScene1();
						glPopMatrix();
						
						glPushMatrix();
						glTranslatef( 0.0 , 2.5 , 0.0 );
						drawScene1();
						glPopMatrix();
						
						glPushMatrix();
						glTranslatef( 0.0 , 0.0 , 2.5 );
						drawScene1();
						glPopMatrix();
						
						glPushMatrix();
						glTranslatef( -2.5 , 0.0 , 0.0 );
						drawScene1();
						glPopMatrix();
						
						glPushMatrix();
						glTranslatef( 0.0 , 0.0 , -2.5 );
						drawScene1();
						glPopMatrix();
						
						glPushMatrix();
						glTranslatef( 0.0 , -2.5 , 0.0 );
						drawScene1();
						glPopMatrix();
						
					}

					vue_z -= 0.01;
					waiting ++;
					if ( vue_z < -5 )
						scene++;
					
    				break;
			}
		case 7 :
			{
				static unsigned int angle = 0;
				static unsigned int waiting = 0;
				static unsigned int waiting2 = 0;
				static float look_y = 0.0;
				static float look_z = 0.0;
				static bool retour = false;
				static bool retour2 = false;
				//static char rest = 0;
				
				gluLookAt(	0.0f ,10.0, -2.0,
    						look_z, look_y, look_z-look_y,
    						0.0f, 0.0f ,1.0f );  
    			
    			glRotated(angle , 0 , 1 ,1 );
    						
    			for ( float i = -12.5 ; i < 12.5 ; i+=2.5 )
    			{
    				//glTranslated(0, 0, 1);
    				for ( float j = -12.5 ; j < 12.5 ; j+=2.5 )
    				{
    					//glTranslated(0, 1, 0);
    					for ( float k = -12.5 ; k < 12.5 ; k+=2.5 )
    					{
    						glColor3f ( 1-(fabs(i)/12.5), 1-(fabs(j)/12.5), 1-(fabs(k)/12.5) );
    						glPushMatrix();
    						glTranslated(i,j,k);
    						
    						drawScene1();
    						glPopMatrix();
						}
					}
				}
    				angle++;
    				waiting++;
    				
    				if ( waiting >= 400 )
    				{
    					waiting -= 60;
    					if ( !retour )
    					{
    						if ( look_y >= 5.0 )
	    							retour = true;
	    					look_y += 2.5;
						}
    					if ( retour )
    					{	
    						if ( look_y > 0.0 )
								look_y-=2.5;
						}
						if ( !retour2 && retour && look_y <= 0.0 )
						{
							if ( look_z <= -5.0 )
								retour = false;
							look_z-=2.5;
						}
						if ( retour2 && retour && look_y <= 0.0 )
						{
							if ( look_z >= 0.0 )
								scene++;
							look_z+=2.5;
						}
					}
					
    				waiting2++;
    				if ( waiting2 > 1600 )
    					scene++;
    				
    					
					
					
					break;
			}
		case 8 :
			{
				static float vue_y = 15.0;
				
				gluLookAt(	0.0f ,vue_y ,0.0,
    						0.0f, 0.0, 0.0,
    						0.0f, 0.0f ,1.0f );  
    						
    			for ( float i = -12.5 ; i < 12.5 ; i+=2.5 )
    			{
    				//glTranslated(0, 0, 1);
    				for ( float j = -12.5 ; j < 12.5 ; j+=2.5 )
    				{
    					//glTranslated(0, 1, 0);
    					for ( float k = -12.5 ; k < 12.5 ; k+=2.5 )
    					{
    						glColor3f ( 1-(fabs(i)/12.5), 1-(fabs(j)/12.5), 1-(fabs(k)/12.5) );
    						glPushMatrix();
    						glTranslated(i,j,k);
    						
    						drawScene1();
    						glPopMatrix();
						}
					}
				}
				
				vue_y -= 0.1;
				
				if ( vue_y < -72.5 )
					scene++;
				break;
			}
		case 9 :
			{    			
    				static float angle = 0;
    				static float indice = 1;
    				static bool phase = false;

    				
    				gluLookAt(	0.0f ,10.0, 0.0,
    							0.0f, 0.0f, 0.0f,
    							0.0f, 0.0f ,1.0f );
					
					glDisable( GL_LIGHTING);
					
					glRotatef(angle, 0, 1, 0);
						
						if ( !phase )
							glColor3f( 0.0f, 1.0f, 0.0f );
						else
							glColor3f( 1.0f, 1.0f, 0.0f );
						drawScene1();
						
						glColor3f(0.0f, 0.0f, 1.0f );
						glPushMatrix();
						glTranslatef( 2.5 , 0.0 , 0.0 );
						drawScene1();
						glPopMatrix();
						glPushMatrix();
						
						if ( !phase )
							glRotatef( -2 , 0 ,1 ,0);
						else
							glRotatef( -14 , 0 ,1 ,0);
						glTranslatef( 3.5 , 0.0 , 0.0 );
						glRotatef(-95, 0 , 1 , 0 );
						if ( !phase )
							drawPlane2(cocoon);
						else
							drawPlane2(division);
						glPopMatrix();
						
						glColor3f(0.0f, 0.0f, 1.0f );
						
						glPushMatrix();	// m'en fous
						glTranslatef( 0.0 , 2.5 , 0.0 );
						drawScene1();
						glPopMatrix();
						
						glPushMatrix();
						glTranslatef( 0.0 , 0.0 , 2.5 );
						drawScene1();
						glPopMatrix();
						glPushMatrix();
						if ( !phase )
							glRotatef( 7, 0 , 1 , 0 );
						else
							glRotatef( -9, 0 , 1 , 0 );
						glTranslatef( 0.0 , 0.0 , 3.5 );
						glRotatef ( 180 , 0 , 1 , 0 );
						if ( !phase )
							drawPlane2(dtv);
						else
							drawPlane2(sector);
						glPopMatrix();
						
						glColor3f(0.0f, 0.0f, 1.0f );
						
						glPushMatrix();
						glTranslatef( -2.5 , 0.0 , 0.0 );
						drawScene1();
						glPopMatrix();
						glPushMatrix();
						glTranslatef( -3.5 , 0.0 , 0.0 );
						glRotatef(90, 0 , 1 , 0 );
						if ( !phase )
							drawPlane2(sfx);
						else
							drawPlane2(you);
						glPopMatrix();
						
						glColor3f(0.0f, 0.0f, 1.0f );
						
						glPushMatrix();
						glTranslatef( 0.0 , 0.0 , -2.5 );
						drawScene1();
						glPopMatrix();
						glPushMatrix();
						glRotatef(-10, 0 , 1 , 0 );
						glTranslatef( 0.0 , 0.0 , -3.5 );
						if ( !phase )
							drawPlane2(popsy);
						else
						{
							glRotated(5 , 0 , 1 ,0 );
							drawPlane2(mankind);
						}
						glPopMatrix();
						
						glColor3f(0.0f, 0.0f, 1.0f );
						
						glPushMatrix();	// m'en fous
						glTranslatef( 0.0 , -2.5 , 0.0 );
						drawScene1();
						glPopMatrix();
						
					

					angle += 1;
					if ( angle > 360 && !phase )
					{
						phase = true;
					}
					if ( angle > 720 && phase )
					{
						angle += indice;
						indice += 0.02;
					}
					if ( indice > 10 )
					{
						glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	
    					glLoadIdentity();
    					initScene2();
						scene++;
					}
					
    				break;
			}
		case 10 :
			{
				static unsigned int angle = 0;
				static unsigned int angle2 = 0;
				
				glDisable( GL_LIGHTING );
				
				gluLookAt(	0.0f ,10.0, 0.0,
    						0.0f, 0.0f, 0.0f,
    						0.0f, 0.0f ,1.0f );
    						
    			glRotated( angle , 1 , 0 , 0 );
    			glRotated( angle , 0 , 0 , 1 );
    			glRotated( angle2 , 0 , 1 , 0 );
    						
    			drawScene2();
    			
    			angle++;
    			if ( angle % 3 == 0 )
    				angle2++;
    				
    			if ( angle2 > 300 )
    				scene++;
    						
    			break;
			}
			
		case 11 :
			{
				static unsigned int waiting = 0;
					
				if ( waiting > 100 )
					scene++;
						
				waiting++;
					
				break;
			}
			
		case 12 :
			{
				{
				static bool init = true;
				static unsigned int angle = 903;
				static unsigned int angle2 = 301;
				static double indice = 0;

				if ( init )
				{
    				initLight();
    				init = false;
				 }
				
				gluLookAt(	0.0f ,10.0, 0.0,
    						0.0f, 0.0f, 0.0f,
    						0.0f, 0.0f ,1.0f );
    						
    			float sin_calc = sinf(indice)*10;
    				
    				GLfloat light_position1[] = { sin_calc , 0.0 , 0.0 , 1.0 };
    				GLfloat light_position0[] = { sin_calc , 0.0 , sin_calc , 1.0 };
    				GLfloat light_position2[] = { sin_calc , sin_calc , sin_calc , 1.0 };
    				GLfloat light_position3[] = { sin_calc , 0.0 , sin_calc , 1.0 };
    				GLfloat light_position4[] = { 0.0 , sin_calc , 0.0 , 1.0 };
    				GLfloat light_position5[] = { 0.0 , 0.0 , sin_calc , 1.0 };
    				
    				glLightfv(GL_LIGHT0, GL_POSITION, light_position0);
    				glLightfv(GL_LIGHT1, GL_POSITION, light_position1);
    				glLightfv(GL_LIGHT2, GL_POSITION, light_position2);
    				glLightfv(GL_LIGHT3, GL_POSITION, light_position3);
    				glLightfv(GL_LIGHT4, GL_POSITION, light_position4);
    				glLightfv(GL_LIGHT5, GL_POSITION, light_position5);
    						
    			glRotated( angle , 1 , 0 , 0 );
    			glRotated( angle , 0 , 0 , 1 );
    			glRotated( angle2 , 0 , 1 , 0 );
    						
    			drawScene2();
    			
    			angle++;
    			
    			if ( angle % 3 == 0 )
    				angle2++;
    				
    			if ( angle2 > 601 )
    				scene++;

    				
    			indice += 0.05;
    			
    						
    			break;
				}
			}
		
		case 13 :
			{
				static unsigned int waiting = 0;
					
				if ( waiting > 100 )
					scene++;
						
				waiting++;
					
				break;
			}
			
		case 14 :
			{
				{
				static bool init = true;
				static unsigned int angle = 1806;
				static unsigned int angle2 = 602;
				static double indice = 0;
				static double indice2 = 0;
				static double indice3 = 0;
				
				if ( init )
				{
    				initLight();
    				init = false;
				 }
				
				gluLookAt(	0.0f ,10.0, 0.0,
    						0.0f, 0.0f, 0.0f,
    						0.0f, 0.0f ,1.0f );
    						
    			float sin_calc = sinf(indice)*10;
    			float sin_calc2 = sinf(indice2)*10;
    			float sin_calc3 = sinf(indice3)*10;
    				
    				GLfloat light_position1[] = { sin_calc , 0.0 , 0.0 , 1.0 };
    				GLfloat light_position0[] = { sin_calc , 0.0 , sin_calc , 1.0 };
    				GLfloat light_position2[] = { 0.0 , sin_calc2 , 0.0 , 1.0 };
    				GLfloat light_position3[] = { 0.0 , sin_calc3 , 0.0 , 1.0 };
    				GLfloat light_position4[] = { 0.0 , sin_calc , 0.0 , 1.0 };
    				GLfloat light_position5[] = { 0.0 , 0.0 , sin_calc , 1.0 };
    				
    				glLightfv(GL_LIGHT0, GL_POSITION, light_position0);
    				glLightfv(GL_LIGHT1, GL_POSITION, light_position1);
    				glLightfv(GL_LIGHT2, GL_POSITION, light_position2);
    				glLightfv(GL_LIGHT3, GL_POSITION, light_position3);
    				glLightfv(GL_LIGHT4, GL_POSITION, light_position4);
    				glLightfv(GL_LIGHT5, GL_POSITION, light_position5);
    						
    			glRotated( angle , 1 , 0 , 0 );
    			glRotated( angle , 0 , 0 , 1 );
    			glRotated( angle2 , 0 , 1 , 0 );
    						
    			drawScene2();
    			
    			angle++;
    			if ( angle % 3 == 0 )
    				angle2++;
    				
    			if ( angle2 > 903 )
    				scene++;
    				
    			indice += 0.05;
    			indice2 = indice - 20;
    			indice3 = indice2 - 20;	
    			break;
				}
			}
		case 15 :
			{
				static unsigned int waiting = 0;
					
				if ( waiting > 100 )
					scene++;
						
				waiting++;
					
				break;
			}
		case 16 :
			{
				static bool init = true;
				static unsigned int angle = 2709;
				static unsigned int angle2 = 904;
				static double indice = 0;
				
				if ( init )
				{
    				initLight2();
    				init = false;
				 }
				
				gluLookAt(	0.0f ,10.0, 0.0,
    						0.0f, 0.0f, 0.0f,
    						0.0f, 0.0f ,1.0f );
    						
    			float sin_calc = sinf(indice)*10;
    				
    				GLfloat light_position1[] = { sin_calc , 0.0 , 0.0 , 1.0 };
    				GLfloat light_position0[] = { sin_calc , 0.0 , sin_calc , 1.0 };
    				GLfloat light_position2[] = { sin_calc , sin_calc , sin_calc , 1.0 };
    				GLfloat light_position3[] = { sin_calc , 0.0 , sin_calc , 1.0 };
    				GLfloat light_position4[] = { 0.0 , sin_calc , 0.0 , 1.0 };
    				GLfloat light_position5[] = { 0.0 , 0.0 , sin_calc , 1.0 };
    				
    				glLightfv(GL_LIGHT0, GL_POSITION, light_position0);
    				glLightfv(GL_LIGHT1, GL_POSITION, light_position1);
    				glLightfv(GL_LIGHT2, GL_POSITION, light_position2);
    				glLightfv(GL_LIGHT3, GL_POSITION, light_position3);
    				glLightfv(GL_LIGHT4, GL_POSITION, light_position4);
    				glLightfv(GL_LIGHT5, GL_POSITION, light_position5);
    						
    			glRotated( angle , 1 , 0 , 0 );
    			glRotated( angle , 0 , 0 , 1 );
    			glRotated( angle2 , 0 , 1 , 0 );
    						
    			drawScene2();
    			
    			angle++;
    			if ( angle % 3 == 0 )
    				angle2++;
    				
    			if ( angle2 > 1204 )
    				scene++;
    				
    			indice += 0.05;

    						
    			break;
			}
		case 17 :
			{
				static unsigned int waiting = 0;
					
				if ( waiting > 100 )
					scene++;
						
				waiting++;
					
				break;
			}
		case 18 :
			{
				static unsigned int angle = 3612;
				static unsigned int angle2 = 1205;
				
				glDisable( GL_LIGHTING );
				
				gluLookAt(	0.0f ,10.0, 0.0,
    						0.0f, 0.0f, 0.0f,
    						0.0f, 0.0f ,1.0f );
    						
    			glRotated( angle , 1 , 0 , 0 );
    			glRotated( angle , 0 , 0 , 1 );
    			glRotated( angle2 , 0 , 1 , 0 );
    						
    			drawScene2();
    			
    			angle++;
    			if ( angle % 3 == 0 )
    				angle2++;
    				
    			if ( angle2 > 1225 )
    				scene++;
    						
    			break;	
			}
		case 19:
			{
				static unsigned int waiting = 0;
					
				if ( waiting > 120 )
					scene++;
						
				waiting++;
					
				break;
			}
		case 20 :
			{
				static unsigned int angle = 3672;
				static unsigned int angle2 = 1225;
				
				glDisable( GL_LIGHTING );
				
				gluLookAt(	0.0f ,10.0, 0.0,
    						0.0f, 0.0f, 0.0f,
    						0.0f, 0.0f ,1.0f );
    						
    			glRotated( angle , 1 , 0 , 0 );
    			glRotated( angle , 0 , 0 , 1 );
    			glRotated( angle2 , 0 , 1 , 0 );
    						
    			drawScene2();
    			
    			angle++;
    			if ( angle % 3 == 0 )
    				angle2++;
    				
    			if ( angle2 > 1246 )
    				scene++;
    						
    			break;	
			}
		case 21:
			{
				static unsigned int waiting = 0;
				static bool init = true;
				
				if ( init )
				{
					deleteScene2();
					initScene2s();
					init = false;
				}
				
				if ( waiting > 119 )
					scene++;
				
				waiting++;
					
				break;
			}
		case 22 :
			{
				static unsigned int angle = 3732;
				static unsigned int angle2 = 1266;
				static float vue_y = 10.0;
				static float vue_z = 0.0;
				static char texture = 0;
				
				glDisable( GL_LIGHTING );
				
				gluLookAt(	vue_z ,vue_y, vue_z,
    						vue_z, vue_z, vue_z,
    						0.0f, 0.0f ,1.0f );
    						
    			glRotated( angle , 1 , 0 , 0 );
    			glRotated( angle , 0 , 0 , 1 );
    			glRotated( angle2 , 0 , 1 , 0 );
    						
    			drawScene2();
    			glTranslatef ( -0.5 , -0.5 , -0.5 );
    			
    			switch ( texture )
    			{
    				case 0 :
    					drawCubeTex(0.25 , 0.25 , 0.25 , code);
    					break;
    				case 1:
    					drawCubeTex(0.25 , 0.25 , 0.25 , littlewhite);
    					break;
    				case 2:
    					drawCubeTex(0.25 , 0.25 , 0.25 , music);
    					break;
    				case 3:
    					drawCubeTex(0.25 , 0.25 , 0.25 ,okeanos);
    					break;
    			}
    			
    			angle++;
    			if ( angle % 3 == 0 )
    				angle2++;
    				
    			if ( angle2 > 1666 )
    			{
    				//scene++;
    				if ( vue_y > 1.0 )
    				{
    					vue_y -= 0.05;
    					vue_z -= 0.5/180.0;
					}
				}
				
				if ( angle2 > 1926 && texture == 0 )
				{
					texture ++;
				}
				if ( angle2 > 2266 && texture == 1 )
				{
					texture ++;
				}
				if ( angle2 > 2476 && texture == 2 )
				{
					texture ++;
				}
				if ( angle2 > 2686 && texture == 3 )
    			{
    				scene++;
    				deleteScene2();
				}
    						
    			break;	
			}
			
		case 23 :
			{
				static float angle = 0;
    			static float indice = 30;
    			static float r = 1.0;
    			static float g = 1.0;
    			static float b = 1.0;
    			static unsigned char volume = 100;

				glDisable( GL_LIGHTING );
				
				gluLookAt(	0.0f ,10.0, 0.0,
    						0.0f, 0.0f, 0.0f,
    						0.0f, 0.0f ,1.0f );
    				
    			glRotated(angle, 0, 1, 0);
						
				glColor3f( 0.0f, g, 0.0f );
				drawScene1();
						
				glColor3f(r, 0.0f, 0.0f );
				glPushMatrix();
				glTranslatef( 2.5 , 0.0 , 0.0 );
				drawScene1();
				glPopMatrix();
						
				glPushMatrix();
				glTranslatef( 0.0 , 2.5 , 0.0 );
				drawScene1();
				glPopMatrix();
						
				glPushMatrix();
				glTranslatef( 0.0 , 0.0 , 2.5 );
				drawScene1();
				glPopMatrix();
						
				glPushMatrix();
				glTranslatef( -2.5 , 0.0 , 0.0 );
				drawScene1();
				glPopMatrix();
						
				glPushMatrix();
				glTranslatef( 0.0 , 0.0 , -2.5 );
				drawScene1();
				glPopMatrix();
						
				glPushMatrix();
				glTranslatef( 0.0 , -2.5 , 0.0 );
				drawScene1();
				glPopMatrix();
				
				glColor3f(0.0f, 0.0f, b );
				
				glPushMatrix();
				glTranslatef( -5.0 , -5.0 , 0.0 );
				drawScene1();
				glPopMatrix();
				
				glPushMatrix();
				glTranslatef( 5.0 , -5.0 , 0.0 );
				drawScene1();
				glPopMatrix();
				
				glPushMatrix();
				glTranslatef( 0.0 , -5.0 , -5.0 );
				drawScene1();
				glPopMatrix();
				
				glPushMatrix();
				glTranslatef( 0.0 , -5.0 , 5.0 );
				drawScene1();
				glPopMatrix();				
	

				angle += indice;
				if ( indice > 0.0 )
					indice -= 0.1;
				else
				{
					r -= 0.01;
					g -= 0.01;
					b -= 0.01;
					if ( r <= 0 && b <= 0 && g <= 0 )
						scene++;
					if ( volume > 2 )
						volume--;
					(Son::getSon())->setVolume(volume);
				}
				
					
    			break;
			}
		case 24:
			{
				static unsigned int waiting = 0;
				
				if ( waiting > 90 )
					exit(0);
				waiting++;				
			}
		
 	}
	
	glutSwapBuffers();
	
	timer.countFPS();
	timer.waitForFPS();
	
}

void drawAxis()
{	
	glEnable(GL_COLOR_MATERIAL);
		glColorMaterial(GL_FRONT, GL_AMBIENT);
	
	glBegin(GL_LINES);
	
	// X
	glColor3ub(255, 0, 0);
	glVertex3f(0.0 ,0.0 ,0.0);
	glVertex3f(10.0 ,0.0 ,0.0);	
	
	// Y
	glColor3ub(0, 255, 0);
	glVertex3f(0.0 ,10.0 ,0.0);
	glVertex3f(0.0 ,0.0 ,0.0);	
	
	
	// Z
	glColor3ub(0,0,255);
	glVertex3f(0.0 ,0.0 ,0.0);
	glVertex3f(0.0 ,0.0 ,10.0);
	
	glEnd();
	
	glDisable(GL_COLOR_MATERIAL);
	
}

void drawPlane(int tex)
{
	glBindTexture(GL_TEXTURE_2D, tex);
	glBegin(GL_QUADS);
	{
		//glColor3ub(255,255,255);
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 2.5f, 0.0f, 1.0f);
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 2.5f, 0.0f, -1.0f);
		glTexCoord2f(1.0f, 0.0f); glVertex3f( -2.5f, 0.0f, -1.0f);
		glTexCoord2f(1.0f, 1.0f); glVertex3f( -2.5f, 0.0f, 1.0f);
	}
	glEnd();
	glBindTexture(GL_TEXTURE_2D, 0);
}

void drawPlane2(int tex)
{
	glBindTexture(GL_TEXTURE_2D, tex);
	glBegin(GL_QUADS);
	{
		glColor3ub(255,255,255);
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f, 0.0f, 0.25f);
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, 0.0f, -0.25f);
		glTexCoord2f(1.0f, 0.0f); glVertex3f( -1.0f, 0.0f, -0.25f);
		glTexCoord2f(1.0f, 1.0f); glVertex3f( -1.0f, 0.0f, 0.25f);
	}
	glEnd();
	glBindTexture(GL_TEXTURE_2D, 0);
}

void drawCubeTex(float size_x, float size_y , float size_z, int tex)
{
	glBindTexture(GL_TEXTURE_2D, tex);
	glBegin(GL_QUADS);
	{
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-size_x, -size_y,  size_z);	
    	glTexCoord2f(1.0f, 0.0f); glVertex3f( size_x, -size_y,  size_z);	
    	glTexCoord2f(1.0f, 1.0f); glVertex3f( size_x,  size_y,  size_z);	
    	glTexCoord2f(0.0f, 1.0f); glVertex3f(-size_x,  size_y,  size_z);	
    
    // Back Face
    	glTexCoord2f(1.0f, 0.0f); glVertex3f(-size_x, -size_y, -size_z);	
    	glTexCoord2f(1.0f, 1.0f); glVertex3f(-size_x,  size_y, -size_z);	
    	glTexCoord2f(0.0f, 1.0f); glVertex3f( size_x,  size_y, -size_z);	
    	glTexCoord2f(0.0f, 0.0f); glVertex3f( size_x, -size_y, -size_z);	
	
    // Top Face
    	glTexCoord2f(0.0f, 1.0f); glVertex3f(-size_x,  size_y, -size_z);	
    	glTexCoord2f(0.0f, 0.0f); glVertex3f(-size_x,  size_y,  size_z);	
    	glTexCoord2f(1.0f, 0.0f); glVertex3f( size_x,  size_y,  size_z);	
    	glTexCoord2f(1.0f, 1.0f); glVertex3f( size_x,  size_y, -size_z);	
    
    // Bottom Face       
    	glTexCoord2f(1.0f, 1.0f); glVertex3f(-size_x, -size_y, -size_z);	
    	glTexCoord2f(0.0f, 1.0f); glVertex3f( size_x, -size_y, -size_z);	
    	glTexCoord2f(0.0f, 0.0f); glVertex3f( size_x, -size_y,  size_z);	
    	glTexCoord2f(1.0f, 0.0f); glVertex3f(-size_x, -size_y,  size_z);	
    
    // Right face
    	glTexCoord2f(1.0f, 0.0f); glVertex3f( size_x, -size_y, -size_z);	
    	glTexCoord2f(1.0f, 1.0f); glVertex3f( size_x,  size_y, -size_z);	
    	glTexCoord2f(0.0f, 1.0f); glVertex3f( size_x,  size_y,  size_z);	
    	glTexCoord2f(0.0f, 0.0f); glVertex3f( size_x, -size_y,  size_z);	
    
    // Left Face
    	glTexCoord2f(0.0f, 0.0f); glVertex3f(-size_x, -size_y, -size_z);	
    	glTexCoord2f(1.0f, 0.0f); glVertex3f(-size_x, -size_y,  size_z);	
    	glTexCoord2f(1.0f, 1.0f); glVertex3f(-size_x,  size_y,  size_z);	
    	glTexCoord2f(0.0f, 1.0f); glVertex3f(-size_x,  size_y, -size_z);	
    
	}glEnd();
	glBindTexture(GL_TEXTURE_2D, 0);
}

void drawCube(float size_x, float size_y , float size_z, bool wire )
{
	if ( wire )
		glBegin(GL_LINES);
	else
		glBegin(GL_QUADS);
	{
		glVertex3f(-size_x, -size_y,  size_z);	
		glVertex3f( size_x, -size_y,  size_z);	
		glVertex3f( size_x,  size_y,  size_z);	
		glVertex3f(-size_x,  size_y,  size_z);	
		
		// Top Face
		glVertex3f(-size_x,  size_y, -size_z);	
		glVertex3f(-size_x,  size_y,  size_z);	
		glVertex3f( size_x,  size_y,  size_z);	
		glVertex3f( size_x,  size_y, -size_z);	
		
		// Right face
		glVertex3f( size_x, -size_y, -size_z);	
		glVertex3f( size_x,  size_y, -size_z);	
		glVertex3f( size_x,  size_y,  size_z);	
		glVertex3f( size_x, -size_y,  size_z);
		
		// Bottom Face
		glVertex3f(-size_x, -size_y, -size_z);	
		glVertex3f( size_x, -size_y, -size_z);	
		glVertex3f( size_x, -size_y,  size_z);	
		glVertex3f(-size_x, -size_y,  size_z);	
			
		// Left Face
		glVertex3f(-size_x, -size_y, -size_z);	
		glVertex3f(-size_x, -size_y,  size_z);	
		glVertex3f(-size_x,  size_y,  size_z);	
		glVertex3f(-size_x,  size_y, -size_z);
		
		// Back Face
		glVertex3f(-size_x, -size_y, -size_z);	
		glVertex3f(-size_x,  size_y, -size_z);	
		glVertex3f( size_x,  size_y, -size_z);	
		glVertex3f( size_x, -size_y, -size_z);	
	}glEnd();
}
