#include "window.hpp"

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>

#include <iostream>

/**
	Function to construct a window
	@param const char* window_name : name of the window
	@param int argc : number of arguments
	@param char** argv : the arguments
	@param const short int pos_x : position on the x axis of the window
	@param const short int pos_y : position on the y axis of the window
	@param const unsigned short int width : width of the window
	@param const unsigned short int height : height of the window
*/
Window :: Window (const char* window_name, int argc, char** argv, const short int pos_x, const short int pos_y, const unsigned short int width , const unsigned short int height ):width(width),height(height)
{
	std::cout << "Window built" << std::endl;
	
	int screen_size_x = glutGet(GLUT_SCREEN_WIDTH);
	int screen_size_y = glutGet(GLUT_SCREEN_HEIGHT);
	
	std::cout << "Screen resolution  : " << screen_size_x << "x" << screen_size_y << std::endl;
	
	glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH );
	
	
	glutInitWindowSize(width, height); 
	if ( pos_y > 0 && pos_x > 0 )
		glutInitWindowPosition(pos_y, pos_y);
	else
		glutInitWindowPosition((screen_size_x/2)-width/2, (screen_size_y/2)-height/2);
	
	if ( ((window_id = glutCreateWindow(window_name)) == 0) )
	{
		std::cerr << "Error while creating window" << std::endl;
		exit(1);
	}
}

/**
	Function to init OpenGL
	Sets the clear colour.
	Enables the depth test
	Enables the lighting
	Enbales the texture
	The perspective
	And the size of the glPoint
*/
void Window::initGL()
{
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);	
	
	glClearDepth(1.0);
	glDepthFunc(GL_LESS);
	glEnable(GL_DEPTH_TEST);
	
	glShadeModel (GL_SMOOTH);
	
	glEnable(GL_LIGHTING);
	
	glEnable(GL_TEXTURE_2D);
	
	glMatrixMode(GL_PROJECTION);
    glLoadIdentity();			
    
    gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,60.0f);
    
    glMatrixMode(GL_MODELVIEW);
}

/**
	Function to set the callback functions
	@param void (*displayFunc)(void) : function to display the scene
	@param void (*keyboardFunc) (unsigned char, int, int ): function to handle the keyboard's event
	@param void (*mouseEvent) ( int, int, int, int) : function to handle the mouse's event
*/
void Window::handlingFuntion(void (*displayFunc)(void), void (*keyboardFunc) ( unsigned char , int , int ), void (*mouseEvent) ( int, int, int, int))
{
	glutDisplayFunc(displayFunc);
	
	glutIdleFunc(displayFunc);
	
	//glutTimerFunc(16, &refresh , 1 );
	
	glutKeyboardFunc(keyboardFunc);
	
	glutMouseFunc(mouseEvent);
}

Window :: ~Window ()
{
	glutDestroyWindow(window_id);
	
	std::cout << "Window deleted" << std::endl;
}

//void refresh(int value )
//{
	//glutPostRedisplay();
//}
