#include "star.hpp"

#include <GL/gl.h>

#include <stdlib.h>

Star stars[NB_STAR] ;

GLuint obj_stars;

/**
	First function to initialise the stars
	Uses an OpenGL List
*/
void initStars()
{
	// Initialises the position
	for ( int i = 0 ; i < NB_STAR ; i++ )
	{
		stars[i].x = ((float)rand()/RAND_MAX)*20-10;
		stars[i].y = ((float)rand()/RAND_MAX)*20-10;
		stars[i].z = ((float)rand()/RAND_MAX)*20-10;
	}
	
	// Gets a list from OpenGL
	obj_stars = glGenLists(1);
	
	// Start the filling of the list
	glNewList(obj_stars, GL_COMPILE);
	{
		glColor3f( 74 , 138 , 255 );
		glBegin(GL_POINTS);
		{
			for ( int i = 0 ; i < NB_STAR ; i++ )
			{
				glVertex3f( stars[i].x , stars[i].y , stars[i].z );
				glVertex3f( stars[i].x+0.01 , stars[i].y+0.01 , stars[i].z+0.01 );
				glVertex3f( stars[i].x+0.01 , stars[i].y-0.01 , stars[i].z+0.01 );
				glVertex3f( stars[i].x-0.01 , stars[i].y-0.01 , stars[i].z+0.01 );
				glVertex3f( stars[i].x-0.01 , stars[i].y-0.01 , stars[i].z-0.01 );
			}
		}glEnd();
	}
	glEndList();	// End of the list
	
}

/**
	Second function to initialise the stars
	Uses an OpenGL List
*/
void initStars2()
{
	// Initialises the positions
	for ( int i = 0 ; i < NB_STAR ; i++ )
	{
		stars[i].x = ((float)rand()/RAND_MAX)*20;
		stars[i].y = ((float)rand()/RAND_MAX)*20;
		stars[i].z = ((float)rand()/RAND_MAX)*20;
	}
	
	// Gets a list from OpenGL
	obj_stars = glGenLists(1);
	
	// Start the filling of the list
	glNewList(obj_stars, GL_COMPILE);
	{
		glBegin(GL_POINTS);
		{
			for ( int i = 0 ; i < NB_STAR ; i++ )
			{
				glVertex3f( stars[i].x , stars[i].y , stars[i].z );
				glVertex3f( stars[i].x+0.01 , stars[i].y+0.01 , stars[i].z+0.01 );
				glVertex3f( stars[i].x+0.01 , stars[i].y-0.01 , stars[i].z+0.01 );
				glVertex3f( stars[i].x-0.01 , stars[i].y-0.01 , stars[i].z+0.01 );
				glVertex3f( stars[i].x-0.01 , stars[i].y-0.01 , stars[i].z-0.01 );
			}
		}glEnd();
	}
	glEndList();	// End of the list
}

/**
	Function to draw the stars
	Uses a OpenGL list
*/
void drawStars()
{
	glCallList(obj_stars);	
}

/**
	Function to delete the stars
	Uses a OpenGL list
*/
void deleteStars()
{
	glDeleteLists(obj_stars, 1);
}
