#ifndef __TEXTRENDER_HPP__
#define __TEXTRENDER_HPP__

#include <string>
#include <sstream>

#include "global.hpp"

#include "Colour.hpp"

#ifdef _SDL
	#include <SDL/SDL_ttf.h>
#endif

namespace blackbox
{
	class TextRender
	{
		private:

			static TextRender* textRender;

			TextRender();
			~TextRender();

			#ifdef _SDL
				TTF_Font* font;
			#endif

		public:

			static TextRender* getTextRender();
			void renderText(const int x, const int y, const std::string& message,const blackbox::TColour& colour);
			void destroyTextRender();
			
	};
	
	template <typename T>
	std::string toString(const T value)
	{
		// créer un flux de sortie
		std::ostringstream oss;
		// écrire un nombre dans le flux
		oss << value;
		// récupérer une chaîne de caractères
		return oss.str();		
	}
	
	
}

#endif
