#ifndef __WORLD_ENTITIES_HPP__
#define __WORLD_ENTITIES_HPP__

#include "Position.hpp"

namespace EntitiesType
{
	enum
	{
		PLAYER=0,
		SHIP1,	// Enemies types
		SHIP2,
		SHIP3,
		BULLET1,	// Bullets types
		BULLET2,
		BULLET3,
		EXPLOSION1,	// Explosions types
		EXPLOSION2
	};
}

namespace EntitiesState
{
	enum
	{
		NORMAL,
		DIED
	};
}

class World_Entities
{
	private:
		// Position of the object
		Position old_pos;	// For the interpolation

	protected:

		Position pos;

		// Id of the sprites of the objects
		int texture;
		bool isAnimation;
		unsigned int animation_time;	// Just use when it is an animation
		unsigned int animation_counter;	// Just use when it is an animation
		// State of the objects
		unsigned char state;
		// Type of the object
		unsigned char type;

		// Life of the objects ( sometimes not useful )
		int life;

		// The world is fill with autonomous beings
		virtual void move(void)=0;

	public:
		World_Entities(const Position& initial_pos,const unsigned char type);

		void draw(void);
		void update(void);


		// Getters
		unsigned char getState(void) const { return state; };
		unsigned char getType(void) const { return type; };
		int getLife(void) const { return life; };
		int getPosX(void) const { return pos.x; };
		int getPosY(void) const { return pos.y; };
		int getTexture(void) const { return texture; };

		// Do damage
		bool setDamage(const unsigned int damage);
};

#endif
