#include "UI.hpp"

#include "World.hpp"

#include "Visualisation.hpp"
#include "TextRender.hpp"
#include "Colour.hpp"
#include "Output.hpp"

UI :: UI ()
{
	// Load the sprite
	ui = Visualisation::getVisualisation()->addTexture("Data/Gfx/UI.png");

	blackbox::showMessage("UI created");
}

/**
	Function to draw the User Interface on the right of the screen
	The User Interface show the score and the highscore, with a nice background.
*/
void UI::draw(void)const
{
	// Draw the ui background
	Visualisation::getVisualisation()->drawTexture(	ui,
													Visualisation::getVisualisation()->getWidth() - SIZE_UI,
													0);

	// Draw life
	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth() - (SIZE_UI/2 + 8) , 10 , "Life", blackbox::TColour(180,0,32));
	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth() - (SIZE_UI/2 + 6) , 30 , blackbox::toString(World::getWorld()->getPLayerLife()), blackbox::TColour(180,0,32));
	// Draw score
	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth() - (SIZE_UI/2 + 16) , 170 , "Score", blackbox::TColour(180,0,32));
	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth() - (SIZE_UI/2 + 4) , 200 , blackbox::toString(World::getWorld()->getScore()), blackbox::TColour(0,32,180));
	// Draw highscore
	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth() - (SIZE_UI/2 + 32) , 420 , "Highscore", blackbox::TColour(180,0,32));
	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth() - (SIZE_UI/2 + 6) , 440 , blackbox::toString(World::getWorld()->getHighScore()), blackbox::TColour(0,32,180));

	
}

/**
	Function to draw the victory message
*/
void UI::drawWin(void)const
{
	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth()/2 - SIZE_FONT*8 , Visualisation::getVisualisation()->getHeight()/2 , "YOU DEFEAT ALL OF THEM", blackbox::TColour(96,180,32));
}

/**
	Function to draw the defeat message
*/
void UI::drawLose(void)const
{
	blackbox::TextRender::getTextRender()->renderText(Visualisation::getVisualisation()->getWidth()/2 - SIZE_FONT*6 , Visualisation::getVisualisation()->getHeight()/2 , "YOU ARE DEAD", blackbox::TColour(96,180,32));
}

/**
	UI's destructor
*/
UI::~UI(void)
{
	blackbox::showMessage("UI deleted");
}
