#ifndef __SOUND_HPP__
#define __SOUND_HPP__

#include "global.hpp"

#ifdef _SDL
	#include <SDL/SDL_mixer.h>
#endif

#include <string>
#include <vector>

namespace blackbox
{
	class Sound
	{
		private :
			static Sound* sound;
	
			Sound();
			~Sound();

			#ifdef _HAPI
				std::vector<int> bank_sound;
				std::string music;
			#endif

			#ifdef _SDL
				std::vector<Mix_Chunk*> bank_sound;
				std::vector<Mix_Music*> bank_music;
			#endif

		public :

			static Sound* getSound();

			void loadMusic(const std::string& pathname, int* const id);
			void loadSound(const std::string& pathname, int* const id);
		
			void playMusic(const int num);
			void playSound(const int num, const bool loop,const unsigned int volume);

			void stopSound(const int num=-1);
		
			void destroySound();
	};
}

#endif
