#include "Output.hpp"

#include "global.hpp"

#include <string>

#ifdef _HAPI

	#include "HAPI_lib.h"

	void blackbox::showError (const std::string& error_message)
	{
		HAPI->UserMessage(error_message,"Output!");
	}

	void blackbox::showMessage (const std::string& message)
	{
		HAPI->DebugText(message);
	}

#endif

#ifdef _SDL

	#include <iostream>

	void blackbox::showError (const std::string& error_message)
	{
		std::cerr << error_message << std::endl;
	}

	void blackbox::showMessage (const std::string& message)
	{
		std::cout << message << std::endl;
	}

#endif
