#ifndef __POSITION_CPP__
#define __POSITION_CPP__

#include "Interpolation.hpp"

#include "World.hpp"
#include "Time_Manager.hpp"

/**
	Function to interpolate two position
	@param const T& const old_pos : the last object
	@param const T& const new_pos : the next object
	@return T : the interpolate object
*/
template <typename T>
T interpolate(const T& old_pos, const T& new_pos)
{
	// Calculate the coefficient
	float coef = ((float)( blackbox::getTime() - (World::getWorld())->getLastTime() ) / (float)( (World::getWorld())->getNextTime() - (World::getWorld())->getLastTime() )) - 1;

	// Calculate the interpolate position
 	return old_pos + coef * ( new_pos - old_pos );
}

#endif
