#include "Explosion.hpp"

#include "World.hpp"
#include "Visualisation.hpp"
#include "Colour.hpp"
#include "Sound.hpp"
#include "Output.hpp"

#include <iostream>

Explosion :: Explosion(const Position& initial_pos, const unsigned char type):World_Entities(initial_pos,type)
{
	switch ( type )
	{
		case EntitiesType::EXPLOSION1:
			blackbox::showMessage("Explosion type 1 created");
			isAnimation=true;
			break;
		case EntitiesType::EXPLOSION2:
			blackbox::showMessage("Explosion type 2 created");
			isAnimation=true;
			break;
	}
}

void Explosion :: move(void)
{
	if ( this->isAnimation )
	{
		if ( animation_counter > 4 )
			World::getWorld()->deleteElement(this);
	}
}

