#include "Bullet1.hpp"

#include "World.hpp"

#include "Visualisation.hpp"
#include "Colour.hpp"
#include "Sound.hpp"
#include "Output.hpp"

#include "Position.hpp"

/**
	Bullet1's constructor
*/
Bullet1 :: Bullet1(const Position& initial_pos, const int dx, const int dy):Bullet(initial_pos,EntitiesType::BULLET1,10,dx,dy)
{
	isAnimation = true;

	blackbox::showMessage("Bullet Type 1 created");
}

/**
	Function to move the bullet
	Move in a linear way
*/
void Bullet1 :: move(void)
{
	pos.x += dx;
	pos.y += dy;

	// Checks to know if the bullet become useless ( out of screen )
	if ( pos.y < -SIZE_SPRITES ||pos.y > (signed)Visualisation::getVisualisation()->getHeight()-SIZE_UI-SIZE_SPRITES)	// On y axis
	{
		World::getWorld()->deleteElement(this);
		return;
	}

	if ( pos.x < -SIZE_SPRITES || pos.x > (signed)Visualisation::getVisualisation()->getWidth())	// On x axis
	{
		World::getWorld()->deleteElement(this);
		return;
	}	
}
