#ifndef __ANIMATION_HPP__
#define __ANIMATION_HPP__

#include "Texture.hpp"
#include "Colour.hpp"

#include "global.hpp"

#include <vector>

extern bool somethingWrong;

class Animation
{
	private:
		
		unsigned int current_picture;			// The sprite use at this moment
		unsigned long tempo;					// The time between two picture
		unsigned long time;						// Actual time
		
		bool error;
		
		#ifdef _SDL
			Texture* picture;					// Hold all the texture
		
			unsigned int size_x_sprite;
			unsigned int size_y_sprite;
			
			unsigned int offset_x;
			unsigned int offset_y;
			
			unsigned int size_x;
			unsigned int size_y;	
		#endif
		#ifdef _HAPI
			
			vector <Texture*> sequence;			// Hold the sprites separately
			
		#endif
		
	public:
		
		// Constructors
		Animation(const string& picture_name, const unsigned int size_sprite_x, const unsigned int size_sprite_y,const unsigned long tempo);
		Animation(const string& picture_name, const unsigned int size_sprite_x, const unsigned int size_sprite_y,const unsigned long tempo,const blackbox::TColour& transparancy);
		Animation(const string& picture_name, const unsigned int size_sprite_x, const unsigned int size_sprite_y,const unsigned long tempo,const unsigned int offset_x,const unsigned int offset_y,const unsigned int size_x,const unsigned int size_y);
		Animation(const string& picture_name, const unsigned int size_sprite_x, const unsigned int size_sprite_y,const unsigned long tempo,const unsigned int offset_x,const unsigned int offset_y,const unsigned int size_x,const unsigned int size_y,const blackbox::TColour& transparancy);

		~Animation(void);
		
		// Getters
		unsigned int getCurrent(void) const { return current_picture; };
		unsigned int getTempo(void) const { return tempo; };
		unsigned int getTime(void) const { return time; };
		bool checkOutput(void) const { return error; };	// Can be called getOutput()
		
		// Setters
		void setTempo(const unsigned int newTempo) { tempo = newTempo; };
		void setCurrent(const unsigned int new_current) { current_picture = new_current; };
		void setTime(const unsigned int new_time) { time = new_time; };

		// Function to draw the animation
		void drawAnimation(const int x =0 , const int y =0);
		void drawAnimation(const int pos_x , const int pos_y, const unsigned int source_start_x , const unsigned int source_start_y , const unsigned int width , const unsigned int height);
};

#endif
